import {Meta} from '@storybook/react';
import React from 'react';

import {TStorybookFunctionComponent} from '../../../types/storybook';

import {DotSeparator} from './DotSeparator';

export default {
    title: 'Typography/DotSeparator',
    component: DotSeparator,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div>
        {['банан', 'дыня', 'ананас'].map(item => (
            <React.Fragment key={item}>
                {item}
                <DotSeparator />
            </React.Fragment>
        ))}
    </div>
);

Simple.parameters = {
    info: {
        title: 'DotSeparator',
        comment: (
            <>
                Разделитель точка с двумя пробелами.
                <br />
                Последний разделитель в списке детей скрывается автоматически.
            </>
        ),
    },
};
