import {FC, memo} from 'react';

import {
    CHAR_LIST_MARKER,
    CHAR_NBSP,
    CHAR_SPACE,
} from '../../../constants/string/charCodes';

import {IWithClassName} from '../../../types/IWithClassName';

import './DotSeparator.scss';

/*
 * TODO:
 *  css modules
 *  aliases
 */

export interface IDotSeparatorProps extends IWithClassName {}

const SPACE_COUNT = 2;

export const DotSeparatorBase: FC<IDotSeparatorProps> = ({className}) => {
    const before = CHAR_NBSP.repeat(SPACE_COUNT);
    const after = CHAR_SPACE.repeat(SPACE_COUNT);

    return (
        <span
            className={`root ${className}`}
        >{`${before}${CHAR_LIST_MARKER}${after}`}</span>
    );
};

export const DotSeparator = memo(DotSeparatorBase);
