import {ReactNode, FunctionComponent} from 'react';
import {Parameters} from '@storybook/react';
import {BaseDecorators} from '@storybook/addons';

import {IStorybookInfoParameters} from './IStorybookInfoParameters';

interface ICustomParameters extends Parameters {
    info?: IStorybookInfoParameters;
}

interface IStaticStorybookComponent {
    parameters?: ICustomParameters;
    decorators?: BaseDecorators<ReactNode>;
}

export type TStorybookFunctionComponent<T = {}> = FunctionComponent<T> &
    IStaticStorybookComponent;
