import {DecoratorFn} from '@storybook/react';

import {IStorybookInfoParameters} from '../../types/storybook/IStorybookInfoParameters';

// TODO: после переноса этих компонентов, добавить их
// import Box from 'components/Box/Box';
// import Text from 'components/Text/Text';
// import Heading from 'components/Heading/Heading';

export const withInfo: DecoratorFn = (Story, context) => {
    const {title, comment} = (context.parameters.info ||
        {}) as IStorybookInfoParameters;

    if (!title && !comment) {
        return <Story {...context} />;
    }

    return (
        <>
            <div>
                {title && <h3>{title}</h3>}
                {comment && (
                    <div style={{marginBottom: 12}}>
                        <span>{comment}</span>
                    </div>
                )}
            </div>
            <Story {...context} />
        </>
    );
};
