module.exports = (({isProd, isBeta}) => {
    if (isBeta) {
        return {
            bucket: 'travel-frontend',
            version: process.env.BUILD_ID,
            static: {
                path: 'dist',
                sources: ['*.*.(js|css|html)'],
                overwrite: true,
            },
            s3: {
                endpoint: 's3.mdst.yandex.net',
            },
        };
    }

    return {
        bucket: 'travel-frontend',
        version: process.env.BUILD_ID,
        static: {
            path: 'dist',
            sources: ['*.*.(js|css)'],
            overwrite: false,
        },
        freeze: {
            path: 'dist',
            sources: ['client.bundle.js', 'service.html'],
            overwrite: true,
        },
        s3: {
            endpoint: isProd ? 's3.mds.yandex.net' : 's3.mdst.yandex.net',
        },
    };
})({
    isProd: process.env.YENV === 'production',
    isBeta: Boolean(process.env.IS_UNSTABLE),
});
