/* eslint-disable @typescript-eslint/naming-convention */
import {IYaTravelAffiliate} from 'types/IYaTravelAffiliate';

declare global {
    const __BUILD_LANG__: 'ru';
    const __SERVER__: boolean;
    const __HOSTNAME__: string;
    const __BUILD_VERSION__: string;
    const __ENV__: string;

    type Nullable<T> = null | T;
    type PartialRecord<K, V> = Partial<Record<K, V>>;

    // eslint-disable-next-line @typescript-eslint/naming-convention
    interface Window {
        Ya: IYa;
        YaTravelAffiliate?: IYaTravelAffiliate;
        yandex_metrika_callbacks2: ((...args: any[]) => void)[];
    }

    interface IAppData {
        appEnv?: 'beta' | 'development' | 'testing' | 'production';
        jaegerDebugId?: string;
        uid: string;
    }

    interface IYa {
        Rum: IRum;
    }

    module '*.scss' {
        // eslint-disable-next-line import-helpers/order-imports
        import classnames from 'classnames';

        export default classnames;
    }
}
