import {ERumErrorLevel} from 'types/rum/ERumErrorLevel';
import {IRumErrorOptions} from 'types/rum/IRumErrorOptions';

interface IRum {
    initErrors(settings: IErrorCounterSettings): void;
    logError: (
        /** https://a.yandex-team.ru/arcadia/frontend/packages/rum-counter */
        options: IRumErrorOptions,
        error?: Error,
    ) => void;
    ERROR_LEVEL: {
        INFO: ERumErrorLevel.INFO;
        DEBUG: ERumErrorLevel.DEBUG;
        WARN: ERumErrorLevel.WARN;
        ERROR: ERumErrorLevel.ERROR;
        FATAL: ERumErrorLevel.FATAL;
    };
}
