import path from 'path';
import fs from 'fs-extra';
import {Builder} from '@yandex-data-ui/i18n-ts';

import i18nConfig from '../../.i18nrc.json';
import {readFromFiles} from './readFromFiles';

const {
    tanker: {
        project: TRAVEL_TANKER_PROJECT,
        defaultBranch: TRAVEL_TANKER_BRANCH,
    },
} = i18nConfig;

const [i18nPath] = process.argv.slice(2);
const BUILD_FOLDER = path.join(i18nPath, 'keysets');
const TIMER_LABEL = 'Execution time';

(async function readFromFilesAndBuild(): Promise<void> {
    console.time(TIMER_LABEL);

    try {
        fs.ensureDirSync(i18nPath);

        const translations = await readFromFiles();

        const builder = new Builder({
            outFolder: BUILD_FOLDER,
            tankerLinkOptions: {
                base: 'https://tanker.yandex-team.ru',
                isNewTanker: true,
                branch: TRAVEL_TANKER_BRANCH,
                project: TRAVEL_TANKER_PROJECT,
            },
        });

        await builder.build(translations);

        console.log('Tanker built success');
    } catch (e) {
        const message = e instanceof Error ? e.message : String(e);

        console.error(
            message,
            TRAVEL_TANKER_PROJECT,
            'Tanker built with errors',
        );

        throw e;
    }

    console.timeEnd(TIMER_LABEL);
})().catch(e => {
    console.error(e);

    process.exit(1);
});
