import * as typograf from 'typograf';

const {default: Typograf} = typograf;

const LOCALES = ['ru', 'en-US'];
const TYPOGRAF_RULES = [
    'common/nbsp/afterShortWord',
    'common/nbsp/beforeShortLastNumber',
    'common/nbsp/beforeShortLastWord',
    'ru/nbsp/abbr',
    'ru/nbsp/addr',
    'ru/nbsp/afterNumberSign',
    'ru/nbsp/beforeParticle',
    'ru/nbsp/centuries',
    'ru/nbsp/dayMonth',
    'ru/nbsp/groupNumbers',
    'ru/nbsp/initials',
    'ru/nbsp/mln',
    'ru/nbsp/ooo',
    'ru/nbsp/page',
    'ru/nbsp/rubleKopek',
    'ru/nbsp/see',
    'ru/nbsp/year',
    'ru/nbsp/years',
];

export default function typografBuilder(): typograf.Typograf {
    const tp = new Typograf({locale: LOCALES});

    tp.disableRule('*');
    TYPOGRAF_RULES.forEach(rule => tp.enableRule(rule));

    return tp;
}
