import {
    IHotelsSuggest,
    TSuggestGroups,
} from 'types/hotels/common/ISearchSuggest';
import {TGeoId} from 'types/hotels/hotel/IGeoRegion';
import {IHotelIdentifier} from 'types/hotels/hotel/IHotel';
import {IBaseErrorResponse} from 'api/types/IBaseErrorResponse';
import {EGeoLocationStatus} from 'types/common/browserGeolocation';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';

/* 1. RequestParams */

export interface ISearchSuggestRequestParams extends IHotelIdentifier {
    query?: string;
    geoId?: TGeoId;
    limit: number;
    language: string;
    domain: string;
    regionSlug?: TGeoRegionSlug;
    sessionId: string;
    requestIndex: number;
    pathname?: string;
    geoLocationStatus?: EGeoLocationStatus;
    userCoordinates?: string;
}

/* 2. SuccessResponse */

export interface ISearchSuggestGroupsResponse {
    groups: TSuggestGroups;
}

export interface ISearchSuggestResponse {
    items: IHotelsSuggest[];
}

/* 3. ErrorResponse */

export interface ISearchSuggestError extends IBaseErrorResponse {}
