import {
    ISearchSuggestRequestParams,
    ISearchSuggestResponse,
} from 'api/types/ISearchSuggest';
import {IBaseSuccessResponse} from 'api/types/IBaseSuccessResponse';

import {HttpClient} from 'utilities/httpClient/httpClient';

export class WidgetsApi extends HttpClient {
    constructor() {
        super({baseURL: '/api/hotels'});
    }

    searchSuggest = (
        searchSuggestParams: ISearchSuggestRequestParams,
    ): Promise<IBaseSuccessResponse<ISearchSuggestResponse>> =>
        this.get<IBaseSuccessResponse<ISearchSuggestResponse>>(
            'searchSuggest',
            {
                params: searchSuggestParams,
            },
        );
}

export const widgetsApi = new WidgetsApi();
