import {FunctionComponent, useCallback, useMemo, useState} from 'react';

import BottomSheetManagerContext from './BottomSheetManagerContext';

export interface IBottomSheetManager {
    onLayerOpened: (layer: number) => void;
    onLayerClosed: (layer: number) => void;
    isLastLayer: (layer: number) => boolean;
    hasOpenedLayers: () => boolean;
}

const BottomSheetManager: FunctionComponent = ({children}) => {
    const [openedLayers, setOpenedLayers] = useState<number[]>([]);

    const onLayerOpened = useCallback(
        (layer: number): void => {
            setOpenedLayers([...openedLayers, layer]);
        },
        [openedLayers],
    );

    const onLayerClosed = useCallback(
        (layer: number): void => {
            setOpenedLayers(openedLayers.filter(l => l !== layer));
        },
        [openedLayers],
    );

    const isLastLayer = useCallback(
        (layer: number): boolean => {
            return openedLayers[openedLayers.length - 1] === layer;
        },
        [openedLayers],
    );

    const hasOpenedLayers = useCallback((): boolean => {
        return openedLayers.length > 0;
    }, [openedLayers]);

    const managerInstance = useMemo(
        () => ({onLayerOpened, onLayerClosed, isLastLayer, hasOpenedLayers}),
        [onLayerOpened, onLayerClosed, isLastLayer, hasOpenedLayers],
    );

    return (
        <BottomSheetManagerContext.Provider value={managerInstance}>
            {children}
        </BottomSheetManagerContext.Provider>
    );
};

export default BottomSheetManager;
