import React, {PureComponent} from 'react';

import {ECalendarScrollSource} from 'components/Calendar/types';

import {ICalendarProps} from 'components/Calendar/Calendar';

export type TCalendarScrollContainerProps = Omit<
    ICalendarProps,
    'scrollPartPosition' | 'lastScrollSource'
>;

export interface ICalendarScrollContainerState {
    scrollPartPosition: 0;
    source: Nullable<ECalendarScrollSource>;
    withAnimation: boolean;
}

export default function (CalendarComponent: React.FC<ICalendarProps>) {
    return class CalendarScrollContainer extends PureComponent<
        TCalendarScrollContainerProps,
        ICalendarScrollContainerState
    > {
        readonly state: ICalendarScrollContainerState = {
            scrollPartPosition: 0,
            source: null,
            withAnimation: false,
        };

        /**
         * Пришлось убрать private для декларации типов
         * @see https://github.com/microsoft/TypeScript/issues/35822
         */
        handleScroll = ({
            scrollPartPosition,
            source,
        }: Pick<
            ICalendarScrollContainerState,
            'scrollPartPosition' | 'source'
        >): void => {
            const withAnimation = source === ECalendarScrollSource.MONTHS_LIST;
            const newScroll =
                scrollPartPosition ?? this.state.scrollPartPosition;

            this.setState({
                scrollPartPosition: newScroll,
                source,
                withAnimation,
            });
        };

        render(): React.ReactNode {
            const {scrollPartPosition, source, withAnimation} = this.state;

            return (
                <CalendarComponent
                    scrollPartPosition={scrollPartPosition}
                    lastScrollSource={source}
                    withAnimation={withAnimation}
                    onScroll={this.handleScroll}
                    {...this.props}
                />
            );
        }
    };
}
