import {FC, memo} from 'react';
import {Spring, animated} from 'react-spring';

import ScrollController from './components/ScrollController/ScrollController';

export interface ICalendarScrollControllerProps {
    scrollTop: number;
    scrollNode: Nullable<HTMLElement>;
    withoutAnimation: boolean;
    onSpringRest?: () => void;
}

const AnimatedScrollContainer = animated(ScrollController);

const CalendarScrollController: FC<ICalendarScrollControllerProps> = props => {
    const {
        scrollTop = 0,
        scrollNode = null,
        withoutAnimation = true,
        onSpringRest,
    } = props;

    if (withoutAnimation) {
        return null;
    }

    return (
        <Spring
            from={{scrollTop: scrollNode?.scrollTop}}
            to={{scrollTop}}
            onRest={onSpringRest}
        >
            {({scrollTop: scrollTopValue}): React.ReactElement => {
                return (
                    <AnimatedScrollContainer
                        scrollNode={scrollNode}
                        scrollTopValue={scrollTopValue}
                    />
                );
            }}
        </Spring>
    );
};

export default memo(CalendarScrollController);
