import {TMonthNumber} from 'components/Calendar/types';

import getUTCDateByParams from './getUTCDateByParams';

/**
 * Update date years without change original days and months
 *
 * @param date {Date} - original date
 * @param yearCount {number} - integer years for change original date
 *
 * @return {Date} - updated date by yearCount
 */

export default (date: Date, yearCount: number = 1): Date => {
    const year = date.getUTCFullYear();
    const month = date.getUTCMonth() as TMonthNumber;
    const day = date.getUTCDate();

    return getUTCDateByParams({year: year + yearCount, month, day});
};
