import {DAYS_IN_WEEK} from 'components/Calendar/constants/constants';

import {ICalendarMonth} from 'components/Calendar/types';

import {getNow} from 'utilities/dateUtils';

const MIN_EMPTY_DAYS_FOR_MOVE_MONTH_LABEL = 2;

export function canMoveMonthLabel(month: ICalendarMonth): boolean {
    const nowDate = new Date(getNow());
    const isCurrentMonthFirst = month.month === nowDate.getUTCMonth();
    const isCurrentWeekFirst = month.monthDays
        .slice(0, DAYS_IN_WEEK)
        .some(day => day && day.day === nowDate.getUTCDate());
    const canMove = month.monthDays
        .slice(0, MIN_EMPTY_DAYS_FOR_MOVE_MONTH_LABEL)
        .every(day => day === false);

    return (!isCurrentMonthFirst || isCurrentWeekFirst) && canMove;
}
