import getUTCDateByDate from './getUTCDateByDate';

const MILLISECONDS_IN_DAY = 86400000;

export default (startDate: Date, endDate: Date): number => {
    const preparedStartDate = getUTCDateByDate(startDate);
    const preparedEndDate = getUTCDateByDate(endDate);

    return Math.round(
        (Number(preparedEndDate) - Number(preparedStartDate)) /
            MILLISECONDS_IN_DAY,
    );
};
