import {MONTHS_IN_YEAR} from 'components/Calendar/constants/constants';

import getUTCDateByDate from './getUTCDateByDate';

export default (endDate: Date, startDate: Date): number => {
    const preparedEndDate = getUTCDateByDate(endDate);
    const preparedStartDate = getUTCDateByDate(startDate);
    const yearDiff =
        preparedEndDate.getUTCFullYear() - preparedStartDate.getUTCFullYear();
    const monthDiff =
        preparedEndDate.getUTCMonth() - preparedStartDate.getUTCMonth();

    return yearDiff * MONTHS_IN_YEAR + monthDiff;
};
