import {TMonthNumber} from 'calendar-base';
import moment from 'moment';

import capitalizeFirstLetter from 'utilities/strings/capitalizeFirstLetter';

type TOptions = {
    monthIndex: TMonthNumber;
};

export default ({monthIndex}: TOptions): string => {
    const months = moment.months();

    return capitalizeFirstLetter(months[monthIndex]);
};
