import _last from 'lodash/last';

import {DAYS_IN_WEEK} from '../constants/constants';

import {ICalendarDay} from '../types';

export default (
    monthDays: (ICalendarDay | false)[],
): (ICalendarDay | false)[][] =>
    monthDays.reduce<(ICalendarDay | false)[][]>(
        (monthWeeks, monthDay, monthDayIndex) => {
            const lastWeek = _last(monthWeeks) ?? [];

            if (monthDayIndex % DAYS_IN_WEEK === 0) {
                monthWeeks.push([monthDay]);
            } else {
                lastWeek.push(monthDay);
            }

            return monthWeeks;
        },
        [],
    );
