import {ICalendarDay} from 'components/Calendar/types';

export default ({year, month, day}: ICalendarDay, now?: Date): Date => {
    const hours = (now && now.getUTCHours()) || 0;
    const minutes = (now && now.getUTCMinutes()) || 0;
    const seconds = (now && now.getUTCSeconds()) || 0;

    return new Date(Date.UTC(year, month, day, hours, minutes, seconds));
};
