import React from 'react';

import Box, {IBoxProps} from '../Box/Box';

import cx from './Card.scss';

export type TCardShadow = 'default' | 'popup' | 'none';
export type TCardRadius = 'xs' | 's' | 'm' | 'l';
export type TCardBorder = 'thin' | 'normal';

export interface ICardProps extends IBoxProps {
    shadow?: TCardShadow;
    radius?: TCardRadius;
    border?: TCardBorder;

    /**
     * Желтая рамка при наведении
     */
    withHover?: boolean;
}

const Card: React.FC<ICardProps> = React.forwardRef<HTMLElement, ICardProps>(
    ({shadow, withHover, radius = 'l', border, className, ...props}, ref) => (
        <Box
            className={cx(
                'card',
                {card_withHover: withHover},
                shadow && `card_shadow_${shadow}`,
                radius && `card_radius_${radius}`,
                border && ['card_border', `card_border_${border}`],
                className,
            )}
            ref={ref}
            {...props}
        />
    ),
);

Card.displayName = 'Card';

export default Card;
