import {FunctionComponent} from 'react';

import Box, {IBoxProps} from 'components/Box/Box';

import cx from './Center.scss';

interface ICenterProps extends IBoxProps {
    vertical?: boolean;
    horizontal?: boolean;
}

export const Center: FunctionComponent<ICenterProps> = ({
    vertical = true,
    horizontal = true,
    className,
    ...rest
}) => {
    const cn = cx('center', className, {
        center_vertical: vertical,
        center_horizontal: horizontal,
    });

    return <Box {...rest} className={cn} />;
};

export default Center;
