import React from 'react';

import {ECalendarType} from 'components/Calendar/types';

import Button, {IButtonProps} from 'components/Button/Button';

import cx from './DatePickerFooter.scss';

export interface IDatePickerFooterProps {
    visible?: boolean;

    messageText?: string;

    buttonDisabled?: boolean;
    buttonText?: string;
    showButton?: boolean;
    onButtonClick?: IButtonProps['onClick'];
}

export interface IDatePickerFooterPropsByCalendarType {
    [ECalendarType.START_DATE]?: IDatePickerFooterProps;
    [ECalendarType.END_DATE]?: IDatePickerFooterProps;
}

const DatePickerFooter: React.FC<IDatePickerFooterProps> = ({
    buttonText,
    showButton,
    buttonDisabled,
    onButtonClick,
    messageText,
    visible,
}) => {
    if (!visible) {
        return null;
    }

    return (
        <div className={cx('container')}>
            {messageText && <div className={cx('message')}>{messageText}</div>}

            {showButton && (
                <Button
                    width="max"
                    theme="primary"
                    size="l"
                    disabled={buttonDisabled}
                    onClick={onButtonClick}
                >
                    {buttonText}
                </Button>
            )}
        </div>
    );
};

export default DatePickerFooter;
