import {EDatePickerSelectionMode} from 'components/DatePicker/types';

import isAfterDay from 'components/Calendar/utilities/isAfterDay';
import isSameDay from 'components/Calendar/utilities/isSameDay';

export interface IGetDateTriggerTextData {
    startDate: Nullable<Date>;
    endDate: Nullable<Date>;
    hoveredDate: Nullable<Date>;
    selectionMode: EDatePickerSelectionMode;
}

export interface IGetTriggerTextParams {
    left: Nullable<Date>;
    right: Nullable<Date>;
    highlightLeft: boolean;
    highlightRight: boolean;
}

export default function getDateTriggerTextParams({
    startDate,
    endDate,
    hoveredDate,
    selectionMode,
}: IGetDateTriggerTextData): IGetTriggerTextParams {
    let left = null;
    let highlightLeft = false;
    let highlightRight = false;
    let right = null;

    if (selectionMode === EDatePickerSelectionMode.START_DATE && !endDate) {
        // Выбирается первая дата
        left = hoveredDate ?? startDate;
        highlightLeft =
            Boolean(
                hoveredDate && startDate && !isSameDay(hoveredDate, startDate),
            ) || Boolean(hoveredDate && !startDate);
    } else if (selectionMode === EDatePickerSelectionMode.END_DATE) {
        // Выбирается вторая дата
        left = startDate;

        right = hoveredDate ?? endDate;
        highlightRight = Boolean(hoveredDate);
    } else if (
        selectionMode === EDatePickerSelectionMode.START_DATE &&
        endDate &&
        !hoveredDate
    ) {
        // Выбран интервал
        left = startDate;
        right = endDate;
    } else if (
        selectionMode === EDatePickerSelectionMode.START_DATE &&
        endDate &&
        hoveredDate
    ) {
        // Диапазон выбран, выбирается новый
        left = hoveredDate;
        highlightLeft = true;
    }

    if (left && right && isAfterDay(left, right)) {
        return {
            left: right,
            right: left,
            highlightLeft: highlightRight,
            highlightRight: highlightLeft,
        };
    }

    return {left, highlightLeft, right, highlightRight};
}
