import React from 'react';

import {IErrorBooster} from 'types/errorBooster/IErrorBooster';

interface IErrorBoundaryProps {
    errorBooster: IErrorBooster;
    renderError?: () => React.ReactNode;
    handleError?: (error?: Error, errorInfo?: React.ErrorInfo) => void;
}

interface IErrorBoundaryState {
    hasError: boolean;
}

class ErrorBoundary extends React.Component<
    IErrorBoundaryProps,
    IErrorBoundaryState
> {
    readonly state: IErrorBoundaryState = {
        hasError: false,
    };

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void {
        const {handleError, errorBooster} = this.props;

        this.setState({hasError: true});

        if (handleError) {
            handleError(error, errorInfo);
        }

        try {
            errorBooster.error(
                {
                    message: '[YATRAVEL] render error',
                    source: errorInfo.componentStack,
                },
                error,
            );
        } catch (e) {}
    }

    render(): React.ReactNode {
        if (this.state.hasError) {
            if (!this.props.renderError) {
                return null;
            }

            return this.props.renderError();
        }

        return this.props.children;
    }
}

export default ErrorBoundary;
