import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import cx from './Heading.scss';

export type THeadingLevel = '1' | '2' | '3' | 1 | 2 | 3;

export type TFontWeight = 'normal' | 'medium' | 'bold';

interface IHeadingProps extends IWithClassName {
    level: THeadingLevel;
    /** По спеке для h3 можно задавать толщину шрифта */
    fontWeight?: TFontWeight;
    tag?: keyof JSX.IntrinsicElements;
    tagProps?: React.HTMLAttributes<any>;
    onClick?: React.MouseEventHandler;
}

const Heading: React.FC<IHeadingProps> = ({
    className,
    fontWeight,
    level,
    tag,
    tagProps,
    children,
    onClick,
    ...rest
}) => {
    const levelTag = getHeadingTag(level);
    const Tag = tag || levelTag;

    return (
        <Tag
            {...tagProps}
            {...rest}
            className={cx(levelTag, className, {
                [`h3_${fontWeight}`]:
                    (level === 3 || level === '3') && fontWeight,
            })}
            onClick={onClick}
        >
            {children}
        </Tag>
    );
};

function getHeadingTag(level: THeadingLevel): 'h1' | 'h2' | 'h3' {
    switch (level) {
        case '1':
        case 1:
            return 'h1';
        case '2':
        case 2:
            return 'h2';
        case '3':
        case 3:
            return 'h3';
    }
}

export default Heading;
