import React, {FunctionComponent} from 'react';
import classnames from 'classnames';

import {IWithClassName} from 'types/IWithClassName';
import {TInputSize} from 'components/Input/types/InputProps';

import {cnInput} from 'components/Input/cnInput';
import CloseCircle from 'icons/16/CloseCircle';

import cx from './InputIcon.scss';

const ICON_SIZE_MAP: Record<TInputSize, number> = {
    s: 12,
    m: 16,
    'm-inset': 16,
    l: 16,
};

interface IInputIconProps extends IWithClassName {
    icon: JSX.Element | undefined;
    size?: TInputSize;
    type: 'left' | 'right';
    hasClear?: boolean;
    onClearClick?: () => void;
}

const InputIcon: FunctionComponent<IInputIconProps> = ({
    className,
    icon,
    size = 'm',
    type,
    hasClear,
    onClearClick,
}) => {
    if (!icon && !hasClear) {
        return null;
    }

    return (
        <span
            className={classnames(
                className,
                cnInput('Icon', {type}),
                hasClear && cx('clearIcon'),
            )}
            onClick={hasClear ? onClearClick : undefined}
        >
            {hasClear ? (
                <CloseCircle
                    width={ICON_SIZE_MAP[size]}
                    height={ICON_SIZE_MAP[size]}
                />
            ) : (
                icon &&
                React.cloneElement(
                    icon,
                    {
                        width: ICON_SIZE_MAP[size],
                        height: ICON_SIZE_MAP[size],
                    },
                    [],
                )
            )}
        </span>
    );
};

export default InputIcon;
