import React from 'react';
import {compose, composeU} from '@bem-react/core';

import {
    Textinput,
    ITextinputProps,
    withViewDefault,
} from '@yandex-lego/components/Textinput/desktop';
import {cnInput} from 'components/Input/cnInput';
// sizes
import {withSizeS} from 'components/Input/_size/Input_size_s';
import {withSizeM} from 'components/Input/_size/Input_size_m';
import {withSizeMInset} from 'components/Input/_size/Input_size_m-inset';
import {withSizeL} from 'components/Input/_size/Input_size_l';

interface IInputPresenterProps extends ITextinputProps {}

const YTLegoTextInputWrapper: React.FC<IInputPresenterProps> = props => (
    <Textinput {...props} className={cnInput(null, [props.className])} />
);

export const InputPresenter = compose(
    composeU(withSizeS, withSizeM, withSizeMInset, withSizeL),
    withViewDefault,
)(YTLegoTextInputWrapper);
