import {ITextinputProps} from '@yandex-lego/components/Textinput/desktop';

export interface IInputChangeEvent {
    target: HTMLInputElement;
}

export type TInputSize = 's' | 'm' | 'm-inset' | 'l';

export interface IInputProps
    extends Omit<ITextinputProps, 'onChange' | 'size'> {
    size?: TInputSize | undefined;
    maxLength?: number;
    disabledAutocompleteFix?: boolean;
    inputRef?: (input: HTMLInputElement | null) => void;
    onChange?: (event: IInputChangeEvent, value: string) => any;
    hasClear?: boolean;
}
