import {FC, InputHTMLAttributes} from 'react';

import {IWithClassName} from 'types/IWithClassName';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import {ILinkProps as LinkProps} from '@yandex-lego/components/Link/desktop';
import {LegoLinkPresenter} from 'components/Link/controls/LegoLinkPresenter';

import cx from './Link.scss';

export type TLinkThemeType =
    | 'normal'
    | 'alert'
    | 'black'
    | 'ghost'
    | 'outer'
    | 'brand'
    | 'light'
    | 'none';

export interface ILinkProps extends LinkProps, IWithClassName {
    url: string;
    cls?: never;
    theme?: TLinkThemeType;
    text?: string;
    download?: boolean;
    controlAttrs?: InputHTMLAttributes<HTMLElement>;
}

const Link: FC<ILinkProps> = props => {
    const deviceType = useDeviceType();
    const {
        url,
        controlAttrs,
        className,
        children,
        text,
        theme = 'normal',
        ...rest
    } = props;

    return (
        <LegoLinkPresenter
            href={url}
            theme={theme as any}
            view="default"
            className={cx(
                'root',
                deviceModDesktop('root', deviceType),
                'Link_lego',
                `Link_theme_${theme}`,
                className,
            )}
            {...controlAttrs}
            {...rest}
        >
            {children || text}
        </LegoLinkPresenter>
    );
};

export default Link;
