import React, {ChangeEventHandler, FC, ReactNode, useCallback} from 'react';

import cx from './RadioButtonSlideOption.scss';

export interface IRadioButtonSlideOptionProps {
    value: string;
    children: ReactNode;
    name?: string;
    id?: string;
    checked?: boolean;
    disabled?: boolean;
    className?: string;
    width?: number;
    onClick?(value: string): void;
}

const RadioButtonSlideOption: FC<IRadioButtonSlideOptionProps> = ({
    value,
    checked,
    onClick,
    className,
    disabled,
    width = 0,
    children,
}) => {
    const handleOnChange = useCallback<ChangeEventHandler<HTMLInputElement>>(
        event => {
            onClick?.(event.target.value);
        },
        [onClick],
    );

    return (
        <label
            className={cx('label', className, {disabled, checked})}
            style={{width}}
        >
            <input
                type="radio"
                autoComplete="off"
                className={cx('input')}
                value={value}
                checked={checked}
                disabled={disabled}
                onChange={handleOnChange}
            />
            <div className={cx('content')}>{children}</div>
        </label>
    );
};

export default React.memo(RadioButtonSlideOption);
