import React, {useCallback} from 'react';

import {IWithClassName} from 'types/IWithClassName';
import {EWhenSpecialValues} from 'types/common/When';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getWhenSpecialValueText from 'utilities/dateUtils/when/getWhenSpecialValueText';

import Button from 'components/Button/Button';

interface IWhenButtonProps extends IWithClassName {
    value: EWhenSpecialValues;
    onClick(value: string): void;
}

const WhenButton: React.FC<IWhenButtonProps> = props => {
    const {className, value, onClick} = props;

    const deviceType = useDeviceType();
    const handleClick = useCallback(() => onClick(value), [onClick, value]);

    return (
        <Button
            className={className}
            size={deviceType.isMobile ? 'l' : 'm'}
            width="max"
            onClick={handleClick}
        >
            {getWhenSpecialValueText(value)}
        </Button>
    );
};

export default WhenButton;
