import {EWhenSpecialValues} from 'types/common/When';

import isSpecialWhen from 'utilities/dateUtils/when/isSpecialWhen';
import getWhenMomentFromSpecialWhen from 'utilities/dateUtils/when/getWhenMomentFromSpecialWhen';

export default function getFormattedDate(
    date: EWhenSpecialValues | string | null,
): Date | null {
    if (date === null) {
        return null;
    }

    if (isSpecialWhen(date)) {
        return getWhenMomentFromSpecialWhen(date).toDate();
    }

    return new Date(date);
}
