import React from 'react';

import {
    ESearchFormFieldName,
    TSearchFormTypeAndValue,
} from 'components/SearchForm/types';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';
import SwapHorizontalIcon from 'icons/16/SwapHorizontal';

interface IReverseDirectionButtonProps {
    wrapperClassName: string;
    buttonClassName: string;
    storeField(typeAndValue: TSearchFormTypeAndValue): void;
    from: ISuggestValue<any>;
    to: ISuggestValue<any>;
    setFromPoint(point: ISuggestValue<any>): void;
    setToPoint(point: ISuggestValue<any>): void;
    onInteract?(val: boolean): void;
    onClick?(): void;
}

const ReverseDirectionButton: React.FC<
    IReverseDirectionButtonProps
> = props => {
    const {
        wrapperClassName,
        buttonClassName,
        storeField,
        from,
        to,
        setFromPoint,
        setToPoint,
        onInteract,
        onClick,
    } = props;

    const handleClickReverseDirections = useImmutableCallback(() => {
        storeField({
            type: ESearchFormFieldName.FROM,
            value: to,
        });
        storeField({
            type: ESearchFormFieldName.TO,
            value: from,
        });
        setFromPoint(to);
        setToPoint(from);

        onClick?.();
    });

    const handleFocusReverseDirections = useImmutableCallback(() => {
        onInteract?.(true);
    });

    const handleBlurReverseDirections = useImmutableCallback(() => {
        onInteract?.(false);
    });

    return (
        <div className={wrapperClassName}>
            <button
                className={buttonClassName}
                type="button"
                tabIndex={-1}
                onClick={handleClickReverseDirections}
                onFocus={handleFocusReverseDirections}
                onBlur={handleBlurReverseDirections}
            >
                <SwapHorizontalIcon fill="#808080" />
            </button>
        </div>
    );
};

export default React.memo(ReverseDirectionButton);
