import React, {MouseEventHandler, FormEventHandler} from 'react';
import _noop from 'lodash/noop';

import {IWithClassName} from 'types/IWithClassName';

import cx from './SubmitButton.scss';

interface ISubmitButtonProps extends IWithClassName {
    label: string;
    isSimple?: boolean;
    onClick?: MouseEventHandler;
    onSubmit?: FormEventHandler;
}

const SubmitButton: React.FC<ISubmitButtonProps> = props => {
    const {
        onClick = _noop,
        onSubmit = _noop,
        className,
        label,
        isSimple = false,
    } = props;

    return (
        <button
            type="submit"
            className={cx(
                'submitButton',
                {
                    submitButton_simple_yes: isSimple,
                },
                className,
            )}
            onClick={onClick}
            onSubmit={onSubmit}
        >
            <div className={cx('text')}>{label}</div>
        </button>
    );
};

export default SubmitButton;
