import {useMemo} from 'react';
import throttle from 'lodash/throttle';

const REQUEST_SUGGESTS_THROTTLE_TIME = 300;

export default function useRequestSuggestsWithThrottle<
    T extends (...args: any) => any,
>(requestSuggests: T): T {
    return useMemo(() => {
        return throttle(requestSuggests, REQUEST_SUGGESTS_THROTTLE_TIME);
    }, [requestSuggests]);
}
