import {useCallback} from 'react';

import {ESearchFormFieldName} from '../types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

type TSuggestInputFocusHandler = (fieldName: ESearchFormFieldName) => void;
type TRequestSuggests<T, S = T> = (
    fromField: ISuggestValue<T>,
    toField: ISuggestValue<S>,
) => void;

export default function useSuggestInputFocusHandler<T, S = T>(
    fromField: ISuggestValue<T>,
    toField: ISuggestValue<S>,
    requestSuggests: TRequestSuggests<T, S>,
): TSuggestInputFocusHandler {
    const deviceType = useDeviceType();

    return useCallback(
        (fieldName: ESearchFormFieldName) => {
            if (deviceType.isDesktop) {
                return;
            }

            if (fieldName === ESearchFormFieldName.FROM) {
                requestSuggests(
                    {
                        ...fromField,
                        inputValue: '',
                    },
                    toField,
                );
            } else if (fieldName === ESearchFormFieldName.TO) {
                requestSuggests(fromField, {
                    ...toField,
                    inputValue: '',
                });
            }
        },
        [toField, fromField, requestSuggests, deviceType],
    );
}
