import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

export enum ESearchFormFieldName {
    FROM = 'from',
    TO = 'to',
    START_DATE = 'startDate',
    END_DATE = 'endDate',
}

export function isSearchFormFieldName(
    candidate: unknown,
): candidate is ESearchFormFieldName {
    return Object.values(ESearchFormFieldName).some(v => v === candidate);
}

export enum ESearchFormBorderColor {
    YELLOW = 'yellow',
    GRAY = 'gray',
}

export enum ESearchFormStyleType {
    DEFAULT = 'default',
    ROUNDED = 'rounded',
}

export enum ESearchFormTriggerViewType {
    UNION = 'union',
    TILE = 'tile',
}

export enum ESearchFormSize {
    S = 's',
    M = 'm',
    XL = 'xl',
}

export type TSearchFormErrors = PartialRecord<ESearchFormFieldName, string[]>;

export interface ISearchFormValues {
    [ESearchFormFieldName.FROM]?: ISuggestValue<any>;
    [ESearchFormFieldName.TO]?: ISuggestValue<any>;
    [ESearchFormFieldName.START_DATE]: string | null;
    [ESearchFormFieldName.END_DATE]?: string | null;
}

export interface ISearchFormSuggests<SuggestItem> {
    [ESearchFormFieldName.FROM]: SuggestItem[] | null;
    [ESearchFormFieldName.TO]: SuggestItem[] | null;
}

export type TSearchFormTypeAndValue =
    | {
          type: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
          value: ISuggestValue<any>;
      }
    | {
          type: ESearchFormFieldName.START_DATE;
          value: string | null;
      };
