import React, {ReactNode} from 'react';

import {IIconProps} from 'icons/types/icon';
import {IWithDeviceType} from 'types/IWithDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import {ISuggestItemHandlers} from '../../SearchSuggest';

import cx from './CrossSaleSearchSuggest.scss';

export interface ICrossSaleSearchSuggestProps extends IWithDeviceType {
    groupName: string;
    isActiveElement: boolean;
    title: string | ReactNode;
    description?: string | ReactNode;
    suggestItemHandlers?: ISuggestItemHandlers;
    Icon?: React.FunctionComponent<IIconProps>;
}

function CrossSaleSearchSuggest({
    groupName,
    isActiveElement,
    title,
    description,
    suggestItemHandlers,
    deviceType,
    Icon,
}: ICrossSaleSearchSuggestProps): React.ReactElement {
    return (
        <>
            {groupName && (
                <Text
                    className={cx('suggestListTitle')}
                    size="s-inset"
                    color="link"
                    tag="div"
                >
                    {groupName}
                </Text>
            )}

            <Flex
                className={cx(
                    'suggestItem',
                    {
                        suggestItem_active: isActiveElement,
                    },
                    deviceMods('suggestItem', deviceType),
                )}
                justifyContent="flex-start"
                alignItems="center"
                tagProps={{...suggestItemHandlers}}
            >
                {Icon && <Icon className={cx('icon')} />}

                <Flex flexDirection="column">
                    <Text
                        className={cx('suggestItemTitle')}
                        size="m"
                        color="link"
                    >
                        {title}
                    </Text>
                    {description && (
                        <Text size="s" color="link-pale">
                            {description}
                        </Text>
                    )}
                </Flex>
            </Flex>
        </>
    );
}

export default CrossSaleSearchSuggest;
