import {
    ISearchSuggestRedirectParams,
    ESearchSuggestItemType,
} from 'types/hotels/common/ISearchSuggest';

import {IBaseSuggestItem} from 'components/SearchSuggest/SearchSuggest';

export default function isPersonalSuggest(
    item: IBaseSuggestItem & {
        redirectParams?: ISearchSuggestRedirectParams;
    },
): boolean {
    return (
        item.redirectParams?.type === ESearchSuggestItemType.CROSS_SALE ||
        item.redirectParams?.type === ESearchSuggestItemType.CROSS_SEARCH
    );
}
