import React, {FunctionComponent} from 'react';
import _noop from 'lodash/noop';

import {IWithClassName} from 'types/IWithClassName';

import ArrowBottomIcon from 'icons/12/ArrowBottom';

import cx from './SelectButton.scss';

interface ISelectButtonProps extends IWithClassName {
    onClick?: () => void;
    buttonRef?: React.RefObject<HTMLDivElement>;
}

const SelectButton: FunctionComponent<ISelectButtonProps> = ({
    className,
    children,
    onClick = _noop,
    buttonRef = _noop,
}) => {
    return (
        <div
            className={cx('button', className)}
            onClick={onClick}
            ref={buttonRef}
        >
            <div>{children}</div>
            <div className={cx('buttonIcon')}>
                <ArrowBottomIcon />
            </div>
        </div>
    );
};

export default SelectButton;
