import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/IWithClassName';

import {TBoxSizes} from 'components/Box/Box';

import cx from './Separator.scss';

export interface ISeparatorProps extends IWithClassName {
    /**
     * Вертикальный разделитель
     */
    isVertical?: boolean;
    /**
     * Марджин со всех 4х сторон, в относительных единицах к базовому размеру $base-space
     */
    margin?: TBoxSizes;
    /**
     * CSS height
     */
    height?: number | string;
    /**
     * CSS width
     */
    width?: number | string;
}

const Separator: FunctionComponent<ISeparatorProps> = ({
    className,
    margin = 0,
    isVertical = false,
    width,
    height,
}) => (
    <div
        className={cx(
            'root',
            {[`margin_${margin}`]: Boolean(margin)},
            isVertical ? 'vertical' : 'horizontal',
            className,
        )}
        style={{height, width}}
    />
);

export default Separator;
