import React, {FC} from 'react';

import {IWithClassName} from 'types/IWithClassName';

import {SpinnerPresenter} from './controls/SpinnerPresenter';

export type TSpinnerSize = 'xxs' | 'xs' | 's' | 'm' | 'l' | 'xl' | 'xxl';

export type TSpinnerView = 'default';

export interface ISpinnerProps extends IWithClassName {
    /**
     * Тема
     *
     * @default 'default'
     */
    view?: TSpinnerView;

    /**
     * Размер
     *
     * @default 'm'
     */
    size?: TSpinnerSize;

    progress?: boolean;

    innerRef?: React.RefObject<HTMLDivElement>;
}

const Spinner: FC<ISpinnerProps> = props => {
    const {
        className,
        size = 'm',
        view = 'default',
        innerRef,
        progress = true,
    } = props;

    return (
        <SpinnerPresenter
            className={className}
            size={size}
            view={view}
            progress={progress}
            innerRef={innerRef}
        />
    );
};

export default Spinner;
