import React from 'react';

import {IWithClassName} from 'types/IWithClassName';
import {
    TTextColor,
    TOverflow,
    TTextAlign,
    TTextSize,
    TTextWeight,
    TWhiteSpace,
} from './types';

import {
    alignCn,
    overflowCn,
    textColorCn,
    textSizeCn,
    textWeightCn,
    whiteSpaceCn,
} from './utilities/mods';

import cx from './Text.scss';

export interface ITextProps extends IWithClassName {
    /**
     * Вес текста
     *
     * @default 'normal'
     */
    weight?: TTextWeight;
    /**
     * Размер текста
     *
     * @default 'm'
     */
    size?: TTextSize;
    /**
     * Цвет текста
     *
     * @default 'primary'
     */
    color?: TTextColor;
    disabled?: boolean;
    whiteSpace?: TWhiteSpace;
    align?: TTextAlign;
    onClick?: () => void;
    tag?: keyof JSX.IntrinsicElements;
    tagProps?: React.HTMLAttributes<any> & React.PropsWithRef<any>;
    overflow?: TOverflow;
}

const Text: React.FC<ITextProps> = ({
    className,
    weight = 'normal',
    size = 'm',
    color = 'primary',
    disabled,
    whiteSpace,
    align,
    onClick,
    children,
    tag,
    tagProps,
    overflow,
    ...rest
}) => {
    const Tag = tag || 'span';

    return (
        <Tag
            onClick={onClick}
            {...tagProps}
            className={cx(
                className,
                textSizeCn(size),
                textWeightCn(weight),
                textColorCn(color),
                whiteSpace ? whiteSpaceCn(whiteSpace) : undefined,
                alignCn(align),
                overflowCn(overflow),
                disabled && 'disabled',
            )}
            {...rest}
        >
            {children}
        </Tag>
    );
};

export default Text;
