import {
    TTextColor,
    TOverflow,
    TTextAlign,
    TTextSize,
    TTextWeight,
    TWhiteSpace,
} from '../types';

import cx from '../Text.scss';

export const textSizeCn = (size: TTextSize): string => cx(`size_${size}`);

export const textWeightCn = (weight: TTextWeight): string =>
    cx(`weight_${weight}`);

export const textColorCn = (color: TTextColor): string => cx(`color_${color}`);

export const whiteSpaceCn = (whitePace: TWhiteSpace): string =>
    cx(`whiteSpace_${whitePace}`);

export const alignCn = (align: TTextAlign | undefined): string | undefined =>
    align ? cx(`align_${align}`) : undefined;

export const overflowCn = (
    overflow: TOverflow | undefined,
): string | undefined => (overflow ? cx(`overflow_${overflow}`) : undefined);
