import React, {useMemo} from 'react';

import {YANDEX_ROOT_PATH} from 'constants/common';

import {EProjectName} from 'types/EProjectName';
import {IWithClassName} from 'types/IWithClassName';

import {getTravelLogoUrlByProject} from './utilities/getTravelLogoByProject';

// TODO elyoskin bezanyu: хорошо бы было использовать иконки и текст "Путешествия" в одном экземпляре
// просто меняя размеры. Тогда вместо 9 импортов можно оставить 4.
// Сейчас это не получилось сделать из-за разных непропроциональных отсупов между элементами при разных размерах. Возможно стоит немного подвигать элементы в логотипе, чтобы можно было ресайзом получать touch-версию.
import DesktopIndexLogoTravel from 'icons/illustrations/Desktop/DesktopIndexLogoTravel';
import DesktopIndexLogoTravelSign from 'icons/illustrations/Desktop/DesktopIndexLogoTravelSign';
import DesktopIndexLogoYandex from 'icons/illustrations/Desktop/DesktopIndexLogoYandex';
import DesktopInnerLogoTravel from 'icons/illustrations/Desktop/DesktopInnerLogoTravel';
import DesktopInnerLogoTravelSign from 'icons/illustrations/Desktop/DesktopInnerLogoTravelSign';
import DesktopInnerLogoYaSign from 'icons/illustrations/Desktop/DesktopInnerLogoYaSign';
import TouchLogoTravel from 'icons/illustrations/Touch/TouchLogoTravel';
import TouchLogoTravelSign from 'icons/illustrations/Touch/TouchLogoTravelSign';
import TouchLogoYaSign from 'icons/illustrations/Touch/TouchLogoYaSign';

import cx from './YandexTravelLogo.scss';

interface IYandexTravelLogoProps extends IWithClassName {
    project?: EProjectName;
    withYandexLogo?: boolean;
    isSmall?: boolean;
    travelLogoLabelClassName?: string;
    url?: string;
}

const YandexTravelLogo: React.FC<IYandexTravelLogoProps> = props => {
    const {
        className,
        project,
        withYandexLogo,
        isSmall,
        travelLogoLabelClassName,
        url,
    } = props;

    const yandexLogoUrl = url || YANDEX_ROOT_PATH;
    const travelLogoUrl = url || getTravelLogoUrlByProject(project);

    const yandexLogo = useMemo(() => {
        if (isSmall) {
            return (
                <TouchLogoYaSign
                    className={cx('yandexLogoSign_hasSmallSign')}
                />
            );
        }

        if (withYandexLogo) {
            return (
                <DesktopInnerLogoYaSign
                    className={cx('yandexLogoSign_hasSign')}
                />
            );
        }

        return (
            <DesktopIndexLogoYandex className={cx('yandexLogoSign_hasLabel')} />
        );
    }, [withYandexLogo, isSmall]);

    const travelLogo = useMemo(() => {
        if (isSmall) {
            return (
                <>
                    <TouchLogoTravelSign
                        className={cx('travelLogoSign_hasSmallSign')}
                    />
                    <TouchLogoTravel
                        className={cx(
                            'travelLogoLabel_isSmall',
                            travelLogoLabelClassName,
                        )}
                    />
                </>
            );
        }

        if (withYandexLogo) {
            return (
                <>
                    <DesktopInnerLogoTravelSign
                        className={cx('travelLogoSign_withYandexLogo')}
                    />
                    <DesktopInnerLogoTravel
                        className={cx('travelLogoLabel_withYandexLogo')}
                    />
                </>
            );
        }

        return (
            <>
                <DesktopIndexLogoTravelSign
                    className={cx('travelLogoSign_withYandexLabel')}
                />
                <DesktopIndexLogoTravel
                    className={cx('travelLogoLabel_withYandexLabel')}
                />
            </>
        );
    }, [withYandexLogo, isSmall, travelLogoLabelClassName]);

    return (
        <div
            className={cx(
                'yandexTravelLogo',
                {
                    yandexTravelLogo_touch: isSmall,
                },
                className,
            )}
        >
            <a href={yandexLogoUrl} className={cx('link')}>
                {yandexLogo}
            </a>

            <a href={travelLogoUrl} className={cx('link', 'link_travel')}>
                {travelLogo}
            </a>
        </div>
    );
};

export default React.memo(YandexTravelLogo);
