import {URLs} from 'constants/urls';

import {EProjectName} from 'types/EProjectName';

const DEFAULT_TRAVEL_LOGO_URL = '/';

/* Utilities */
export const getTravelLogoUrlByProject = (project?: EProjectName): string => {
    switch (project) {
        case EProjectName.AVIA:
        case EProjectName.BUSES:
        case EProjectName.HOTELS:
        case EProjectName.TRAINS: {
            return URLs[project];
        }

        default: {
            return DEFAULT_TRAVEL_LOGO_URL;
        }
    }
};
