import {IDevice} from 'types/IDevice';
import {IDeviceOS} from 'types/IDeviceOS';

/**
 * Простой способ определения десктоп/мобайл
 * https://developer.mozilla.org/en-US/docs/Web/HTTP/Browser_detection_using_the_user_agent#mobile_tablet_or_desktop
 */
const MOBILE_USER_AGENT_REGEXP = /Mobi/;

function isMobile(): boolean {
    return MOBILE_USER_AGENT_REGEXP.test(window.navigator.userAgent);
}

function isDesktop(): boolean {
    return !MOBILE_USER_AGENT_REGEXP.test(window.navigator.userAgent);
}

function isTouch(): boolean {
    return 'ontouchstart' in window;
}

// TODO: добавить определение системы
function getOS(): IDeviceOS {
    return {
        version: '',
        name: '',
    };
}

export function detectDevice(): IDevice {
    return {
        isTouch: isTouch(),
        isMobile: isMobile(),
        isDesktop: isDesktop(),
        os: getOS(),
    };
}
