import {createContext} from 'react';

export const DEFAULT_REDIRECT_DOMAIN = 'https://travel.yandex.ru/';

export interface IConstrutorContextParams {
    pointTo?: {
        hotelSlug?: string;
        regionSlug?: string;
    };
    clid?: string;
    clids?: string[];
    vid?: string;
    vids?: string[];
    redirectDomain: string;
    utmSource?: string;
    utmMedia?: string;
    utmCampaign?: string;
}

const ConstrutorContext = createContext<IConstrutorContextParams>({
    redirectDomain: DEFAULT_REDIRECT_DOMAIN,
});

export default ConstrutorContext;
